<?php
    /*
     *
     * copyright (c) 2013-2022 Heliac Technologies
     * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
     *
     * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
     */

    class VisualizzatoreSezioneADueColonne extends VisualizzatoreComponente {
        private $gestoreTraduzioni;
        private $linguaCorrente;
        private $impostazioni;
        private $gestoreJavascript;
        
        function __construct($db) {
            parent::__construct($db);
        }

        function generaContenutoSezione($dati) {
            $datiSezione = parent::getDb()->leggiSingolaRiga("geec_sezioniADueColonne",$dati["idElemento"]);
            $classiDiv = explode(", ", $datiSezione["proporzioni"]);
            ?>
            <div class="<?php echo $classiDiv[0]." ".$datiSezione["allineamento"] ?>">
                <div class="row">
                    <?php
                        if($datiSezione["idComponenteSezione1"]!=0) {
                            $query = "SELECT c.nome,posizione,tipo,testo,ch.script,idElemento,idSezione,classeSezione,animazione,coloreSfondo,immagineSfondo,videoSfondo,altreOpzioni,aTuttaLarghezza FROM geecB_composizionePagine AS ch JOIN geecB_componenti AS c ON ch.idComponente =c.id WHERE ch.id={$datiSezione["idComponenteSezione1"]} ";
                            $risQuery = parent::getDb()->eseguiQueryLettura($query);
                            $componenteSinistra = $risQuery->fetch_assoc();
                            UtilTemplate::stampaSingoloComponente(parent::getDb(),$this->gestoreJavascript,$this->impostazioni,$componenteSinistra,$this->gestoreTraduzioni,$this->linguaCorrente,"no"); 
                        }
                        else {
                            parent::messaggioDiErrore("Questo componente non è stato impostato");
                        }
                    ?>
                </div>
            </div>
            <div class="<?php echo $classiDiv[1]." ".$datiSezione["allineamento"] ?>">
                <div class="row">
                    <?php 
                        if($datiSezione["idComponenteSezione2"]!=0) {
                            $query = "SELECT c.nome,posizione,tipo,testo,ch.script,idElemento,idSezione,classeSezione,animazione,coloreSfondo,immagineSfondo,videoSfondo,altreOpzioni,aTuttaLarghezza FROM geecB_composizionePagine AS ch JOIN geecB_componenti AS c ON ch.idComponente =c.id WHERE ch.id={$datiSezione["idComponenteSezione2"]}";
                            $risQuery = parent::getDb()->eseguiQueryLettura($query);
                            $componenteDestra = $risQuery->fetch_assoc();
                            UtilTemplate::stampaSingoloComponente(parent::getDb(),$this->gestoreJavascript,$this->impostazioni,$componenteDestra,$this->gestoreTraduzioni,$this->linguaCorrente,"no"); 
                        }
                        else {
                            parent::messaggioDiErrore("Questo componente non è stato impostato");
                        }
                    ?>
                </div>
            </div>
            <?php
        }

        public function getImpostazioni() {
            return $this->impostazioni;
        }

        public function getGestoreJavascript() {
            return $this->gestoreJavascript;
        }

        public function getGestoreTraduzioni() {
            return $this->gestoreTraduzioni;
        }

        public function getLinguaCorrente() {
            return $this->linguaCorrente;
        }
        
        public function setLinguaCorrente($linguaCorrente): void {
            $this->linguaCorrente = $linguaCorrente;
        }
        
        public function setGestoreTraduzioni($gestoreTraduzioni): void {
            $this->gestoreTraduzioni = $gestoreTraduzioni;
        }
        
        public function setImpostazioni($impostazioni): void {
            $this->impostazioni = $impostazioni;
        }

        public function setGestoreJavascript($gestoreJavascript): void {
            $this->gestoreJavascript = $gestoreJavascript;
        }

    }
